/*
 * Decompiled with CFR 0.152.
 */
package no.esito.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class WeakHashSet<E>
extends AbstractSet<E> {
    private final Map<E, Boolean> map = new WeakHashMap<E, Boolean>();

    public static final <E> Set<E> getInstance() {
        return new WeakHashSet<E>();
    }

    private WeakHashSet() {
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public String toString() {
        return this.map.keySet().toString();
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.keySet().equals(o);
    }
}

