/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.util.List;
import no.esito.util.BeanID;
import no.g9.message.Message;
import no.g9.message.MessageConfigurator;
import no.g9.message.MessageSystem;
import org.springframework.beans.factory.annotation.Autowired;

@BeanID(value="messageFactory")
public class MessageFactory {
    private List<MessageConfigurator> configurators;

    @Autowired(required=false)
    public void setConfigurators(List<MessageConfigurator> configurators) {
        this.configurators = configurators;
    }

    List<MessageConfigurator> getConfigurators() {
        return this.configurators;
    }

    public Message getMessage(String id, Object ... args) {
        Message theMessage = new Message(id, args);
        if (this.getConfigurators() == null) {
            return theMessage;
        }
        for (MessageConfigurator messageConfigurator : this.getConfigurators()) {
            if (messageConfigurator.configure(theMessage)) break;
        }
        return theMessage;
    }

    @Deprecated
    public static MessageFactory getInstance() {
        return MessageSystem.getMessageFactory();
    }
}

