/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.util.LinkedList;
import java.util.List;
import no.esito.util.BeanID;
import no.esito.util.ServiceLoader;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageLogger;
import org.springframework.beans.factory.annotation.Autowired;

@BeanID(value="messageLogDispatcher")
public class MessageLogDispatcher {
    private List<MessageLogger> messageLoggers = new LinkedList<MessageLogger>();

    @Autowired(required=false)
    public void setMessageLoggers(List<MessageLogger> messageLoggers) {
        this.messageLoggers = messageLoggers;
    }

    public void addMessageLogger(MessageLogger messageLogger) {
        this.messageLoggers.add(messageLogger);
    }

    public void removeMessageLogger(MessageLogger messageLogger) {
        this.messageLoggers.remove(messageLogger);
    }

    public static MessageLogDispatcher getInstance() {
        MessageLogDispatcher retVal = ServiceLoader.getService(MessageLogDispatcher.class);
        return retVal;
    }

    public void log(Message message, DispatcherContext dispatcherContext) {
        for (MessageLogger messageLogger : this.messageLoggers) {
            messageLogger.log(message, dispatcherContext);
        }
    }

    List<MessageLogger> getMessageLoggers() {
        return this.messageLoggers;
    }
}

