/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.message.DispatcherContext;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageDispatcherSetup;
import no.g9.message.MessageFactory;
import no.g9.service.G9Spring;

public final class MessageSystem {
    private static final Logger log = Logger.getLogger(MessageSystem.class);
    public static final DispatcherContext NO_INTERACTION = new DispatcherContext(){};

    private MessageSystem() {
    }

    public static MessageDispatcher getMessageDispatcher(DispatcherContext dispatcherContext) {
        MessageDispatcherSetup dispatcher = ServiceLoader.getService(MessageDispatcherSetup.class);
        dispatcher.setDispatcherContext(dispatcherContext);
        return dispatcher;
    }

    public static MessageDispatcher getMessageDispatcher() {
        MessageDispatcherSetup dispatcher = ServiceLoader.getService(MessageDispatcherSetup.class);
        return dispatcher;
    }

    public static MessageFactory getMessageFactory() {
        MessageFactory factoryInstance = (MessageFactory)G9Spring.getBean("messageFactory");
        if (factoryInstance == null) {
            log.warn("messageFactory is null - this probably means that this class has not bean loaded by Spring");
            log.warn("Creating a local (non-spring) instance");
            factoryInstance = new MessageFactory();
        }
        if (log.isTraceEnabled()) {
            log.trace("Returning message factory: " + factoryInstance.getClass().getSimpleName());
        }
        return factoryInstance;
    }
}

