/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import no.g9.message.ITextPart;

class NumVarPart
implements ITextPart {
    private static final String LF_REGEXP = "\\\\n";
    private final int varNo;
    private final String defVal;
    private final String prefix;
    private final String suffix;

    public NumVarPart(int pVarNo, String pPfx, String pSfx, String pDfl) {
        if (pVarNo <= 0) {
            throw new IllegalArgumentException("NumVarPart.varNo");
        }
        this.varNo = pVarNo;
        this.defVal = pDfl == null ? "" : pDfl;
        this.prefix = pPfx == null ? "" : pPfx;
        this.suffix = pSfx == null ? "" : pSfx;
    }

    @Override
    public void appendPart(StringBuffer sb, boolean singleLine, Object[] args) {
        String lfRepl = singleLine ? " " : System.getProperty("line.separator");
        int varIndex = this.varNo - 1;
        if (args == null || varIndex >= args.length || args[varIndex] == null) {
            sb.append(this.defVal.replaceAll(LF_REGEXP, lfRepl));
        } else {
            String contrib = "" + args[varIndex];
            if ("".equals(contrib)) {
                sb.append(this.defVal.replaceAll(LF_REGEXP, lfRepl));
            } else {
                sb.append(this.prefix.replaceAll(LF_REGEXP, lfRepl));
                sb.append(contrib);
                sb.append(this.suffix.replaceAll(LF_REGEXP, lfRepl));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("NumVar ");
        sb.append(this.varNo);
        if (!"".equals(this.prefix)) {
            sb.append(" pfx=");
            sb.append(this.prefix);
        }
        if (!"".equals(this.suffix)) {
            sb.append(" sfx=");
            sb.append(this.suffix);
        }
        if (!"".equals(this.defVal)) {
            sb.append(" def=");
            sb.append(this.defVal);
        }
        return sb.toString();
    }
}

