/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import no.esito.log.Logger;
import no.g9.message.Message;
import no.g9.message.MessageConfigurator;
import no.g9.message.MessageText;
import no.g9.message.MessageType;
import no.g9.message.MessageTypeEnum;
import no.g9.message.ReplySetType;

public class PropertyFileConfigurator
implements MessageConfigurator {
    private static final Logger log = Logger.getLogger(PropertyFileConfigurator.class);
    private final Map<String, MessageText> messages = new HashMap<String, MessageText>();
    private final Map<String, String> messageTypes = new HashMap<String, String>();
    private final Map<String, String> messageReplySets = new HashMap<String, String>();
    private final Map<String, String> messageTitles = new HashMap<String, String>();
    private Properties props;
    private String messagePartSep = ";";
    private String messageFileName;
    private boolean isDefaultConfigurator = false;

    public PropertyFileConfigurator(String fileName) {
        this(fileName, false);
    }

    public PropertyFileConfigurator(String fileName, boolean isDefaultConfigurator) {
        this.setMessageFileName(fileName);
        this.loadMessages(this.getMessageFileName());
        log.debug("Loading " + fileName);
        this.isDefaultConfigurator = isDefaultConfigurator;
    }

    @Override
    public synchronized boolean configure(Message msg) {
        ReplySetType msgReplySet;
        String messageID = msg.getMessageID();
        MessageText msgSummaryText = this.messages.get(messageID);
        if (msgSummaryText == null) {
            String propVal = this.props.getProperty(messageID);
            if (propVal != null) {
                String[] propParts = propVal.split(this.messagePartSep, 4);
                msgSummaryText = new MessageText(messageID, propParts[3]);
                this.messages.put(messageID, msgSummaryText);
                this.messageTypes.put(messageID, propParts[0]);
                this.messageReplySets.put(messageID, propParts[1]);
                this.messageTitles.put(messageID, propParts[2]);
            } else {
                return false;
            }
        }
        msg.setMessageText(msgSummaryText.substitute(true, msg.getArgs()));
        msg.setMessageID(messageID);
        msg.setLogLevel(4L);
        MessageType msgType = MessageTypeEnum.fromString(this.messageTypes.get(messageID));
        if (msgType != null) {
            msg.setMsgType(msgType);
        }
        if ((msgReplySet = ReplySetType.fromString(this.messageReplySets.get(messageID))) != null) {
            msg.setValidReplies(msgReplySet);
        }
        MessageText msgTitleText = new MessageText(messageID, this.messageTitles.get(messageID));
        msg.setTitle(msgTitleText.substitute(true, msg.getArgs()));
        return !this.isDefaultConfigurator;
    }

    public String getMessageFileName() {
        return this.messageFileName;
    }

    public void setMessageFileName(String messageFileName) {
        this.messageFileName = messageFileName;
    }

    public String getMessagePartSep() {
        return this.messagePartSep;
    }

    public void setMessagePartSep(String messagePartSep) {
        this.messagePartSep = messagePartSep;
    }

    private void loadMessages(String fileName) {
        try {
            this.props = new Properties();
            InputStream in = null;
            in = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (in == null) {
                String message = "Unable to open message file: " + fileName;
                throw new RuntimeException(message);
            }
            this.props.load(in);
            in.close();
        }
        catch (IOException ex) {
            String message = "Error reading from message file: " + fileName;
            throw new RuntimeException(message, ex);
        }
    }
}

