/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FormatHelper {
    private static char decimalSeparator = '\u0000';
    private static char groupingSeparator = '\u0000';
    private static Locale locale;
    public static final int SIGN_FLOATING_MINUS = -2;
    public static final int SIGN_MINUS = -1;
    public static final int SIGN_NONE = 0;
    public static final int SIGN_PLUS = 1;
    public static final int SIGN_FLOATING_PLUS = 2;

    private FormatHelper() {
    }

    private static boolean addChar(StringBuffer format, char c, boolean signSet) {
        switch (c) {
            case '*': 
            case '9': {
                format.append('0');
                break;
            }
            case '+': 
            case '-': {
                if (!signSet) {
                    format.append('+');
                    signSet = true;
                    break;
                }
                format.append('#');
                break;
            }
            case 'Z': {
                format.append('#');
                break;
            }
            case ',': 
            case '.': {
                format.append(c);
                break;
            }
            case 'B': {
                format.append(' ');
                break;
            }
            default: {
                format.append(c);
            }
        }
        return signSet;
    }

    public static String getNumericFormat(String displayRule) {
        StringBuffer format = new StringBuffer();
        char a = '\u0000';
        boolean signSet = false;
        block4: for (int i = 0; i < displayRule.length(); ++i) {
            char b = displayRule.charAt(i);
            switch (b) {
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '9': 
                case 'B': 
                case 'Z': {
                    if (a != '\u0000') {
                        signSet = FormatHelper.addChar(format, a, signSet);
                    }
                    a = b;
                    continue block4;
                }
                case '(': {
                    if (a == '\u0000') continue block4;
                    int no = 0;
                    b = '\u0000';
                    ++i;
                    while (i < displayRule.length() && Character.isDigit(b = displayRule.charAt(i))) {
                        no = no * 10 + Character.digit(b, 10);
                        ++i;
                    }
                    if (b == ')') {
                        while (no > 0) {
                            signSet = FormatHelper.addChar(format, a, signSet);
                            --no;
                        }
                    }
                    a = '\u0000';
                    continue block4;
                }
            }
        }
        if (a != '\u0000') {
            FormatHelper.addChar(format, a, signSet);
        }
        return format.toString();
    }

    public static int getSign(String displayRule) {
        int sign = 0;
        if (displayRule != null) {
            int index = displayRule.indexOf(45);
            if (index >= 0) {
                sign = displayRule.indexOf(45, index + 1) == -1 ? -1 : -2;
            } else {
                index = displayRule.indexOf(43);
                if (index >= 0) {
                    sign = displayRule.indexOf(43, index + 1) == -1 ? 1 : 2;
                }
            }
        }
        return sign;
    }

    public static String getNumericInputFormat(String displayFormat) {
        StringBuffer format = new StringBuffer();
        boolean decimal = false;
        block6: for (int i = 0; i < displayFormat.length(); ++i) {
            char a = displayFormat.charAt(i);
            switch (a) {
                case '+': {
                    format.insert(0, '+');
                    continue block6;
                }
                case '.': {
                    decimal = true;
                    format.append(a);
                    continue block6;
                }
                case '0': {
                    format.append(a);
                    continue block6;
                }
                case '#': {
                    format.append(decimal ? (char)'0' : (char)a);
                    continue block6;
                }
            }
        }
        return format.toString();
    }

    public static String getDatetimeFormat(String displayRule) {
        String format = displayRule;
        if (format != null) {
            if (format.matches(".*NLS.*")) {
                format = null;
            } else if (format.matches(".*[*Z9]+.*")) {
                format = null;
            } else {
                format = format.replaceAll("cc?", "");
                if ((format = format.replaceAll("q", "")).indexOf("AM") != -1) {
                    format = format.replaceAll("H", "h");
                }
                format = format.replaceAll("AM", "aa");
                format = format.replaceAll("AD|BC", "G");
                format = format.replaceAll("wwww", "EEEE");
                format = format.replaceAll("www", "EEE");
                format = format.replaceAll("w", "F");
                format = format.replaceAll("m", "\ufffd");
                format = format.replaceAll("M", "m");
                format = format.replaceAll("\ufffd", "M");
                format = format.replaceAll("j", "D");
                format = format.replaceAll("W", "w");
                format = format.replaceAll("S\\.SSS", "S.\ufffd\ufffd\ufffd");
                format = format.replaceAll("S\\.SS", "S.\ufffd\ufffd");
                format = format.replaceAll("S\\.S", "S.\ufffd");
                format = format.replaceAll("S", "s");
                format = format.replaceAll("\ufffd", "S");
            }
        }
        return format;
    }

    public static String getDisplayrule(int datatype, String displayrule, int displaylength, int precision, int scale) {
        if (displayrule == null || displayrule.length() == 0) {
            StringBuffer rule = new StringBuffer();
            switch (datatype) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 15: {
                    if (precision == 0) {
                        precision = displaylength;
                    } else if (displaylength > precision) {
                        rule.append('-');
                    }
                    if (scale > 0) {
                        precision = precision - scale - 1;
                    }
                    while (precision > 1) {
                        rule.append('-');
                        --precision;
                    }
                    if (precision == 1) {
                        rule.append('9');
                    }
                    if (scale > 0) {
                        rule.append('.');
                        while (scale > 0) {
                            rule.append('9');
                            --scale;
                        }
                    }
                    displayrule = rule.length() > 0 ? rule.toString() : null;
                    break;
                }
                default: {
                    displayrule = null;
                }
            }
        }
        return displayrule;
    }

    public static char getDecimalSeparator() {
        char ds = decimalSeparator;
        if (ds == '\u0000') {
            ds = new DecimalFormatSymbols(FormatHelper.getLocale()).getDecimalSeparator();
        }
        return ds;
    }

    public static void setDecimalSeparator(char decimalSeparator) {
        FormatHelper.decimalSeparator = decimalSeparator;
    }

    public static char getGroupingSeparator() {
        char gs = groupingSeparator;
        if (gs == '\u0000') {
            gs = new DecimalFormatSymbols(FormatHelper.getLocale()).getGroupingSeparator();
        }
        return gs;
    }

    public static void setGroupingSeparator(char groupingSeparator) {
        FormatHelper.groupingSeparator = groupingSeparator;
    }

    public static Locale getLocale() {
        if (locale == null) {
            FormatHelper.setLocale(Locale.getDefault());
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        FormatHelper.locale = locale;
    }
}

