/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import no.g9.support.ActionType;
import no.g9.support.FindData;

public class ObjectSelection
implements Serializable {
    private String currentRootName;
    private String targetRoleName;
    private String targetMainKey;
    private Map<String, List<Object>> roots = new HashMap<String, List<Object>>();
    private String objectSelectionName;
    private String applicationName;
    private FindData findData;
    private boolean setsContainAllRelated = false;
    private Map<Object, ActionType> actions = null;
    private boolean doParents = true;
    private boolean doOneRelated = true;
    private boolean doFirstLevelManyRelated = true;
    private boolean doAnyLevelManyRelated = true;

    public ObjectSelection(Object currentRoot, String currentRootName, String targetRoleName, String applicationName, String objectSelectionName) {
        this(currentRootName, targetRoleName, applicationName, objectSelectionName);
        this.putRootObject(currentRootName, currentRoot);
    }

    public ObjectSelection(String currentRootName, String targetRoleName, String applicationName, String objectSelectionName) {
        this.currentRootName = currentRootName;
        this.targetRoleName = targetRoleName;
        this.applicationName = applicationName;
        this.objectSelectionName = objectSelectionName;
    }

    public ObjectSelection() {
    }

    public void removeAllRootObjects() {
        this.roots.clear();
    }

    public void putRootObject(String rootName, Object rootObject) {
        LinkedList<Object> rootObjects = new LinkedList<Object>();
        rootObjects.add(rootObject);
        this.putRootObjects(rootName, rootObjects);
    }

    public void putRootObjects(String rootName, List<Object> rootObjects) {
        String keyName = rootName != null ? rootName : this.currentRootName;
        this.roots.put(keyName, rootObjects);
    }

    public Object getRootObject(String rootName) {
        List<Object> objects = this.getRootObjects(rootName);
        return objects != null && objects.size() > 0 ? objects.get(0) : null;
    }

    public List<Object> getRootObjects(String rootName) {
        String keyName = rootName != null ? rootName : this.currentRootName;
        return this.roots.get(keyName);
    }

    public String getCurrentRootName() {
        return this.currentRootName;
    }

    public void setCurrentRootName(String aCurrentRootName) {
        this.currentRootName = aCurrentRootName;
    }

    public String getTargetRoleName() {
        return this.targetRoleName;
    }

    public void setTargetRoleName(String aTargetRoleName) {
        this.targetRoleName = aTargetRoleName;
    }

    public String getObjectSelectionName() {
        return this.objectSelectionName;
    }

    public void setObjectSelectionName(String aObjectSelectionName) {
        this.objectSelectionName = aObjectSelectionName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String aApplicationName) {
        this.applicationName = aApplicationName;
    }

    public FindData getFindData() {
        return this.findData;
    }

    public void setFindData(FindData findData) {
        this.findData = findData;
    }

    public String getTargetMainKey() {
        return this.targetMainKey;
    }

    public void setTargetMainKey(String targetMainKey) {
        this.targetMainKey = targetMainKey;
    }

    public boolean getSetsContainAllRelated() {
        return this.setsContainAllRelated;
    }

    public void setSetsContainAllRelated(boolean setsContainAllRelated) {
        this.setsContainAllRelated = setsContainAllRelated;
    }

    public Map<Object, ActionType> getActions() {
        return this.actions;
    }

    public void setActions(Map<Object, ActionType> actions) {
        this.actions = actions;
    }

    public boolean getDoParents() {
        return this.doParents;
    }

    public void setDoParents(boolean doParents) {
        this.doParents = doParents;
    }

    public boolean getDoOneRelated() {
        return this.doOneRelated;
    }

    public void setDoOneRelated(boolean doOneRelated) {
        this.doOneRelated = doOneRelated;
    }

    public boolean getDoFirstLevelManyRelated() {
        return this.doFirstLevelManyRelated;
    }

    public void setDoFirstLevelManyRelated(boolean doFirstLevelManyRelated) {
        this.doFirstLevelManyRelated = doFirstLevelManyRelated;
    }

    public boolean getDoAnyLevelManyRelated() {
        return this.doAnyLevelManyRelated;
    }

    public void setDoAnyLevelManyRelated(boolean doAnyLevelManyRelated) {
        this.doAnyLevelManyRelated = doAnyLevelManyRelated;
    }

    public String toString() {
        return "ObjectSelection [currentRootName=" + this.currentRootName + ", targetRoleName=" + this.targetRoleName + ", targetMainKey=" + this.targetMainKey + ", roots=" + this.roots + ", objectSelectionName=" + this.objectSelectionName + ", applicationName=" + this.applicationName + ", findData=" + this.findData + ", setsContainAllRelated=" + this.setsContainAllRelated + ", actions=" + this.actions + ", doParents=" + this.doParents + ", doOneRelated=" + this.doOneRelated + ", doFirstLevelManyRelated=" + this.doFirstLevelManyRelated + ", doAnyLevelManyRelated=" + this.doAnyLevelManyRelated + "]";
    }
}

