/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import no.g9.exception.G9ServiceException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.G9Enumerator;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class G9EnumToJavaEnumConverterFactory
implements ConverterFactory<G9Enumerator, Enum> {
    private static final String FACTORY_METHOD_NAME = "get";

    public <T extends Enum> Converter<G9Enumerator, T> getConverter(Class<T> targetType) {
        return new G9EnumToJavaEnumConverter<T>(targetType);
    }

    private static final class G9EnumToJavaEnumConverter<T extends Enum>
    implements Converter<G9Enumerator, T> {
        private Class<T> enumType;
        Method factoryMethod = null;

        public G9EnumToJavaEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
            this.factoryMethod = BeanUtils.findMethod(this.enumType, (String)G9EnumToJavaEnumConverterFactory.FACTORY_METHOD_NAME, (Class[])new Class[]{Integer.TYPE});
            if (this.factoryMethod == null) {
                this.handleException(G9EnumToJavaEnumConverterFactory.FACTORY_METHOD_NAME, new Exception("G9EnumToJavaEnumConverter constructor failed"));
            }
        }

        public T convert(G9Enumerator source) {
            Exception ex = null;
            try {
                return (T)((Enum)this.factoryMethod.invoke(null, source.currentValue));
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            this.handleException(G9EnumToJavaEnumConverterFactory.FACTORY_METHOD_NAME, ex);
            return null;
        }

        private void handleException(String methodOrField, Exception ex) {
            Object[] msgArgs = new Object[]{this.enumType.getClass(), methodOrField, this.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            throw new G9ServiceException(ex, msg);
        }
    }
}

