/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.ws;

import java.util.Collection;
import javax.annotation.Resource;
import no.esito.log.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.convert.ConversionService;
import org.springframework.ws.client.core.WebServiceTemplate;

public abstract class AbstractWSClient
implements InitializingBean {
    private static final Logger logger = Logger.getLogger(AbstractWSClient.class);
    private WebServiceTemplate webServiceTemplate;
    private ConversionService domainTransportConversionService;
    private String webServiceURI;
    private String webServiceRootURI;

    protected Object marshalSendAndReceive(Object requestPayload) {
        return this.webServiceTemplate.marshalSendAndReceive(this.webServiceURI, requestPayload);
    }

    protected abstract String getServiceRequestName();

    @Required
    @Autowired
    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.webServiceTemplate = webServiceTemplate;
    }

    protected <C> C convert(Object source, Class<C> targetType) {
        return (C)this.domainTransportConversionService.convert(source, targetType);
    }

    protected <C> Collection<C> convert(Collection<?> source, Class<C> targetType) {
        return (Collection)this.domainTransportConversionService.convert(source, targetType);
    }

    @Required
    @Resource
    public void setDomainTransportConversionService(ConversionService domainTransportConversionService) {
        this.domainTransportConversionService = domainTransportConversionService;
    }

    @Required
    @Resource
    public void setWebServiceRootURI(String webServiceRootURI) {
        this.webServiceRootURI = webServiceRootURI;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.webServiceRootURI.endsWith("/")) {
            this.webServiceRootURI = this.webServiceRootURI + "/";
        }
        this.webServiceURI = this.webServiceRootURI + this.getServiceRequestName();
        logger.info("Configured with web service URI: " + this.webServiceURI);
    }
}

