/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.xml;

import no.esito.log.Logger;
import no.esito.util.StringUtil;
import no.g9.support.ClientContext;
import no.g9.support.ObjectFactory;
import no.g9.support.ObjectSelection;
import no.g9.support.Registry;
import no.g9.support.xml.XmlConverter;
import org.w3c.dom.Document;

public class DefaultXmlConverter
implements XmlConverter {
    private Logger log = Logger.getLogger(DefaultXmlConverter.class);
    private static final String XML_CONVERTER = ".xmlConverter";
    private static final String CONVERTER_SUFFIX = "XmlConverter";

    @Override
    public Document convert(ObjectSelection objectSelection, ClientContext ctx) {
        return this.getConverter(objectSelection).convert(objectSelection, ctx);
    }

    private XmlConverter getConverter(ObjectSelection objectSelection) {
        String converterName = this.getConverterName(objectSelection);
        this.log.info("Using converter: " + converterName);
        XmlConverter converter = (XmlConverter)ObjectFactory.newObject(converterName);
        return converter;
    }

    private String getConverterName(ObjectSelection objectSelection) {
        String converterName = null;
        String propFileName = objectSelection.getApplicationName() + XML_CONVERTER;
        Registry reg = Registry.getRegistry();
        String propName = null;
        propName = objectSelection.getObjectSelectionName();
        converterName = reg.getApplicationProperty(propFileName, propName);
        if (converterName == null) {
            propName = "ServiceApplication." + objectSelection.getApplicationName() + "." + "DefaultXmlConvertPackage";
            this.log.info("propName: " + propName);
            converterName = reg.getG9Property(propName) + "." + objectSelection.getObjectSelectionName().toLowerCase() + "." + StringUtil.toFirstUpper(objectSelection.getObjectSelectionName()) + CONVERTER_SUFFIX;
        }
        return converterName;
    }
}

