/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.exception;

import no.g9.message.Message;

/**
 * The exception class for client code.
 */
public class G9ClientException extends G9BaseException {

	/**
	 * @param cause (missing javadoc)
	 */
	public G9ClientException(Throwable cause) {
		super(cause);
	}

	/**
	 * @param message (missing javadoc)
	 * @param cause (missing javadoc)
	 */
	public G9ClientException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message (missing javadoc)
	 */
	public G9ClientException(String message) {
		super(message);
	}

	/**
	 * (missing javadoc)
	 */
	public G9ClientException() {
		super();
	}

    /**
     * Constructor with an existing Message.
     *
     * @param errMsg Message
     */
	public G9ClientException(final Message errMsg) {
		super(errMsg);
	}

    /**
     * Constructor with an existing Message and a wrapped exception.
     *
     * @param cause Nested exception
     * @param errMsg Message
     */
	public G9ClientException(final Throwable cause, final Message errMsg) {
		super(cause, errMsg);
	}

}
