/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * Interface common to substitution variables and plain text in parsed messages.
 * Both Cloneable and Serializable.
 */
public interface ITextPart extends java.io.Serializable, Cloneable {

    /**
     * Add this parts contribution to the complete message.
     * 
     * @param sb A StringBuffer to append into.
     * @param singleLine TRUE to ignore line feeds
     * @param args Message arguments... Used at will...
     */
    void appendPart(StringBuffer sb, boolean singleLine, Object[] args);
}
