/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * This interface defines a logger. The message system is configurable to have
 * multiple loggers at the same time. When a message is dispatched all loggers
 * get the opportunity to log the message.
 */
public interface MessageLogger {

	/**
	 * This method logs a message.
	 * @param message The message to log.
	 * @param dispatcherContext The context in which to log.
	 */
	public void log(Message message, DispatcherContext dispatcherContext);

}