/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * Fixed text representing an (ignorable) line feed.
 */
class NewLinePart implements ITextPart {

    /**
     * Default constructor for NewlinePart.
     */
    public NewLinePart() {
        super();
    }

    /**
     * Adds a line separator if <code>singleLine</code> is false, oterwise a
     * space.
     * 
     * @param sb Buffer to append to.
     * @param singleLine If true, add a space, otherwise, a line separator is
     *            added.
     * @param args Ignored.
     * @see ITextPart#appendPart(java.lang.StringBuffer, boolean,
     *      java.lang.Object[])
     * @see System#getProperty(java.lang.String) line.separator
     */
    @Override
    public void appendPart(final StringBuffer sb, final boolean singleLine,
            final Object[] args) {
        if (singleLine) {
            sb.append(" ");
        } else {
            sb.append(System.getProperty("line.separator"));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return "NL";
    }
}
