/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;


/**
 * Describes the severity of a message. One-to-one mapping to the log4j levels, except trace.
 * Can be used for sorting of inline messages.
 */
public enum Severity {
   /**
 *low -&gt; debug
 */
LOW,
   /**
 * moderate -&gt; info
 */
MODERATE,
   /**
 * high -&gt; warn
 */
HIGH,
   /**
 *critical -&gt; error
 */
CRITICAL,
   /**
 *urgent -&gt; fatal
 */
URGENT
}
