/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;


import no.esito.log.Logger;

/**
 * An implementation of the <code>IMsgLogger</code> interface using log4j.
 *
 */
public class SimpleLogger implements MessageLogger {

    /**
     * The log4j <code>Logger</code>
     */
    private final Logger logger;

    /**
     * Create a new <code>SimpleLogger</code>.
     *
     * @param loggerName the log4j <code>Logger</code> name.
     */
    public SimpleLogger(String loggerName) {
        this.logger = no.esito.log.Logger.getLogger(loggerName);
    }

    @Override
    public void log(Message message, DispatcherContext dispatcherContext) {
        MessageType msgType = message.getMsgType();
		if (MessageTypeEnum.DEBUG.equals(msgType) || msgType == null) {
            logger.debug(message, message.getException());
        } else if (MessageTypeEnum.INFO.equals(msgType)
                || MessageTypeEnum.LOG.equals(msgType)) {
            logger.info(message, message.getException());
        } else if (MessageTypeEnum.QWARN.equals(msgType)
                || MessageTypeEnum.SECURITY.equals(msgType)) {
            logger.warn(message, message.getException());
        } else if (MessageTypeEnum.NONE.equals(msgType)) {
            logger.error(message, message.getException());
        } else if (MessageTypeEnum.ERROR.equals(msgType)) {
            logger.error(message, message.getException());
        }
        else if (MessageTypeEnum.INLINE.equals(msgType)) {
            logger.error(message, message.getException());
            for (Message child : message.getMessages())
            logger.error(child, child.getException());
        }
    }

}
