/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * Special substitution variable in a message text.
 * 
 */
class SpecialVarPart implements ITextPart {

    /** Special variable for the '<' character. */
    public static final String VAR_LT = "<";

    /** The ID for this special string. */
    private final String partId;

    /**
     * Default constructor for SpecialVarPart.
     * 
     * @param pPartId Identifier for this part.
     */
    public SpecialVarPart(final String pPartId) {
        super();
        if (pPartId == null) {
            this.partId = "";
        } else {
            this.partId = pPartId;
        }
    }

    /**
     * Appends this variable to the message. If it is a known code, the spesial
     * value is inserted, otherwise the code itself is stored.
     * 
     * @param sb Text to append to
     * @param singleLine Ignored.
     * @param args Current variable set
     */
    @Override
    public void appendPart(final StringBuffer sb, final boolean singleLine,
            final Object[] args) {
        if (this.partId.equals(VAR_LT)) {
            sb.append("<");
        } else {
            sb.append(this.partId);
        }
    }

    @Override
    public String toString() {
        return this.partId;
    }
}
