/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.os;


/**
 * An interface for attribute meta data.
 */
public interface AttributeConstant extends OSConstant {

    /**
     * Returns bean ID of the attribute validator.
     * @return ID of the attribute validator bean
     */
    String getValidatorId();

    /**
     * Returns bean ID of the attribute converter.
     * @return ID of the attribute converter bean
     */
    String getConverterId();

    /**
     * Test if the attribute is a java primitive type.
     * @return <code>true</code> if the attribute is a java primitive.
     */
    boolean isJavaPrimitive();

    /**
     * Returns the attribute type class.
     * @return the class of the attribute type.
     */
    Class<?> getAttributeType();

    /**
     * Test if the attribute is a "foreign" attribute. A foreign attribute
     * is an attribute that is inherited as part of a key.
     * @return <code>true</code> if the attribute is a foreign attribute.
     */
    boolean isForeignAttribute();

    /**
     * Returns the "foreign" attribute's role. A foreign attribute
     * is an attribute that is inherited as part of a key. This method returns the
     * RoleConstant representing the actual role of the foreign attribute.
     * @return the <code>RoleConstant</code> of the foreign attribute or
     *         <code>null</code> if this is a local attribute.
     */
    RoleConstant getForeignAttributeRole();

    /**
     * Return the role this attribute is defined in.
     * @return the attribute's enclosing role.
     */
    RoleConstant getAttributeRole();

    /**
     * Return the display rule of the attribute.
     * @return the display rule, or an empty string if no display rule is given.
     */
    String getDisplayRule();
}
