/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.service.print;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;

/**
 * The interface handles g9's printing.
 */
@BeanID("printService")
@G9PropertyName("PrintService")
public interface PrintService {
    /**
     * Print using the supplied print context.
     *
     * @param ctx - the print context
     * @return the print context or an exception with an error message
     */
    public Object print(PrintContext ctx);
}