/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

import java.io.Serializable;

/**
 * Holds order (sort) info for one property.
 * 
 */
public class FindOrder implements Serializable {

    /**
     * The name of the property to order by.
     */
    private String propertyName;

    /**
     * True if ascending order by the given property.
     */
    private boolean ascending;

    /**
     * True if case insensitive ordering.
     */
    private boolean ignoreCase;

    /**
     * Create a new FindOrder for the given property and ordering direction.
     * 
     * @param propertyName (missing javadoc)
     * @param ascending (missing javadoc)
     */
    public FindOrder(String propertyName, boolean ascending) {
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    /**
     * Create a new ascending FindOrder for the given property.
     * 
     * @param propertyName (missing javadoc)
     * @return (missing javadoc)
     */
    public static FindOrder asc(String propertyName) {
        return new FindOrder(propertyName, true);
    }

    /**
     * Create a new descending FindOrder for the given property.
     * 
     * @param propertyName (missing javadoc)
     * @return (missing javadoc)
     */
    public static FindOrder desc(String propertyName) {
        return new FindOrder(propertyName, false);
    }

    /**
     * @return Returns the ascending.
     */
    public boolean getAscending() {
        return ascending;
    }

    /**
     * True if ascending order by the given property.
     * 
     * @param ascending The ascending to set.
     */
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    /**
     * @return Returns the propertyName.
     */
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * The name of the property to order by.
     * 
     * @param propertyName The propertyName to set.
     */
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    /**
     * @return Returns the ignoreCase.
     */
    public boolean getIgnoreCase() {
        return ignoreCase;
    }

    /**
     * True if case insensitive ordering.
     * 
     * @param ignoreCase The ignoreCase to set.
     */
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

}
