/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.filter;

/**
 * Common interface for role filters.
 *
 */
public interface RoleFilter {

    /**
     * Checks if a role should be included or excluded.
     * @param roleName Name of the role or attribute.
     * @param domainObject The domain object.
     * @return true if the role or attribute passed through this filter.
     */
    public boolean isRoleIncluded(String roleName, Object domainObject);

}
