/*
 * Copyright 2013-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.xml;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

import org.w3c.dom.Document;

/**
 * Common interface for generating xml from an object selection.
 */
@BeanID("xmlConverter")
@G9PropertyName("XmlConverter")
public interface XmlConverter {

    /**
     * Generates a Document based on the supplied ObjectSelection, and any
     * previously added filters and converters.
     *
     * @param os The ObjectSelection to convert
     * @param ctx The client context
     * @return An org.w3c.dom.Document, representing the ObjectSelection
     */
    public Document convert(ObjectSelection os, ClientContext ctx);

}
