/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.util.HashMap;
import java.util.Map;
import no.g9.message.Message;
import no.g9.message.MessageEnums;
import no.g9.message.MessageReply;
import no.g9.message.MessageSystem;

public class MessageReplyType
extends MessageEnums
implements MessageReply {
    private static final Map<Integer, MessageReplyType> values = new HashMap<Integer, MessageReplyType>();
    public static final MessageReplyType REPLY_NO = new MessageReplyType(-1, MessageReplyType.getMessageText("-1907"));
    public static final MessageReplyType REPLY_CANCEL = new MessageReplyType(0, MessageReplyType.getMessageText("-1909"));
    public static final MessageReplyType REPLY_OK = new MessageReplyType(1, MessageReplyType.getMessageText("-1910"));
    public static final MessageReplyType REPLY_YES = new MessageReplyType(1, MessageReplyType.getMessageText("-1908"));
    public static final MessageReplyType REPLY_INFO = new MessageReplyType(2, MessageReplyType.getMessageText("-1911"));
    public static final MessageReplyType REPLY_IGNORE = new MessageReplyType(3, MessageReplyType.getMessageText("-1912"));
    public static final MessageReplyType REPLY_RETRY = new MessageReplyType(4, MessageReplyType.getMessageText("-1913"));
    public static final MessageReplyType REPLY_ABORT = new MessageReplyType(5, MessageReplyType.getMessageText("-1914"));
    public static final MessageReplyType REPLY_NONE = new MessageReplyType(Integer.MAX_VALUE, MessageReplyType.getMessageText("-1915"));

    protected MessageReplyType(int pCode, String pName) {
        super(pCode, pName);
        values.put(this.code, this);
    }

    public static MessageReplyType fromInt(int pCode) {
        return values.get(pCode);
    }

    private static String getMessageText(String msgID) {
        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, new Object[0]);
        return msg.getMessageText();
    }
}

