/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import no.esito.log.Logger;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageLogger;
import no.g9.message.MessageType;
import no.g9.message.MessageTypeEnum;

public class SimpleLogger
implements MessageLogger {
    private final Logger logger;

    public SimpleLogger(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    @Override
    public void log(Message message, DispatcherContext dispatcherContext) {
        MessageType msgType = message.getMsgType();
        if (MessageTypeEnum.DEBUG.equals(msgType) || msgType == null) {
            this.logger.debug(message, message.getException());
        } else if (MessageTypeEnum.INFO.equals(msgType) || MessageTypeEnum.LOG.equals(msgType)) {
            this.logger.info(message, message.getException());
        } else if (MessageTypeEnum.QWARN.equals(msgType) || MessageTypeEnum.SECURITY.equals(msgType)) {
            this.logger.warn(message, message.getException());
        } else if (MessageTypeEnum.NONE.equals(msgType)) {
            this.logger.error(message, message.getException());
        } else if (MessageTypeEnum.ERROR.equals(msgType)) {
            this.logger.error(message, message.getException());
        } else if (MessageTypeEnum.INLINE.equals(msgType)) {
            this.logger.error(message, message.getException());
            for (Message child : message.getMessages()) {
                this.logger.error(child, child.getException());
            }
        }
    }
}

