/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message.metric;

import java.io.Serializable;
import no.g9.message.metric.IMetric;

public class SimpleMetric
implements IMetric,
Serializable {
    private static int instances = 0;
    private String key;
    protected long started = System.currentTimeMillis();
    protected long ended;
    protected long lNo;
    private long no = 0L;
    private long val = 0L;

    protected SimpleMetric() {
        this.key = "SimpleMetric#" + instances;
        SimpleMetric.incrementInstances();
    }

    public SimpleMetric(String pkey) {
        SimpleMetric.incrementInstances();
        this.key = pkey;
    }

    public SimpleMetric(String s, long n, long v) {
        this(s);
        this.no = n;
        this.val = v;
    }

    private static synchronized void incrementInstances() {
        ++instances;
    }

    protected void setEnd() {
        this.ended = System.currentTimeMillis();
        ++this.lNo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void add(long v) {
        ++this.no;
        this.val += v;
    }

    public void addMS() {
        ++this.no;
        this.val += this.getTimer();
        this.reset();
    }

    @Override
    public void clear() {
        this.started = System.currentTimeMillis();
        this.lNo = 0L;
        this.no = 0L;
        this.val = 0L;
    }

    public void reset() {
        this.started = System.currentTimeMillis();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getCount() {
        return this.no;
    }

    @Override
    public long getValue() {
        return this.val;
    }

    @Override
    public long getTimer() {
        this.setEnd();
        return this.ended - this.started;
    }

    @Override
    public IMetric stopTimer() {
        this.setEnd();
        return this;
    }

    @Override
    public void setKey(String newVal) {
        if (newVal == null) {
            throw new IllegalArgumentException("null key");
        }
        this.key = newVal;
    }

    @Override
    public void setCount(long n) {
        this.no = n;
    }

    @Override
    public void setValue(long n) {
        this.val = n;
    }

    public double avg() {
        if (this.no == 0L) {
            if (this.val == 0L) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        return (double)this.val / (double)this.no;
    }

    public double speed() {
        if (this.ended == 0L) {
            return 0.0;
        }
        if (this.started == this.ended) {
            return Double.MAX_VALUE;
        }
        return 1000.0 * (double)this.no / (1.0 * (double)(this.ended - this.started));
    }

    public double volume() {
        if (this.ended == 0L) {
            return 0.0;
        }
        if (this.started == this.ended) {
            return Double.MAX_VALUE;
        }
        return 1000.0 * (double)this.val / (1.0 * (double)(this.ended - this.started));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.key);
        this.setEnd();
        sb.append("\t");
        sb.append(this.lNo);
        sb.append("\t");
        sb.append(this.started - this.ended);
        sb.append("\t");
        sb.append(this.no);
        sb.append("\t");
        sb.append(this.val);
        return sb.toString();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.key.equals(((SimpleMetric)that).key);
    }
}

