/*
 * Decompiled with CFR 0.152.
 */
package no.g9.os;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import no.esito.log.Logger;
import no.g9.os.AttributeConstant;
import no.g9.os.Key;
import no.g9.os.KeyTool;
import no.g9.os.OSRole;
import no.g9.os.RelationCardinality;
import no.g9.os.RelationType;
import no.g9.os.RoleConstant;
import no.g9.support.Visitor;

public abstract class AbstractOSRole<T>
implements OSRole<T> {
    private static final Logger log = Logger.getLogger(AbstractOSRole.class);
    public final RelationCardinality CARDINALITY;
    public final RelationType RELATION_TYPE;
    private final OSRole<?> parentNode;
    private final RoleConstant roleConstant;
    private final List<OSRole<?>> children = new ArrayList();
    protected List<Key> keys;

    protected AbstractOSRole(OSRole<?> parent, RelationType relationType, RelationCardinality cardinality, RoleConstant roleConstant) {
        this.parentNode = parent;
        this.RELATION_TYPE = relationType;
        this.CARDINALITY = cardinality;
        this.roleConstant = roleConstant;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public RelationType getRelationType() {
        return this.RELATION_TYPE;
    }

    @Override
    public RelationCardinality getRelationCardinality() {
        return this.CARDINALITY;
    }

    @Override
    public Map<AttributeConstant, Object> getAttributeValues(Object domainInstance) {
        AttributeConstant[] attributes;
        HashMap<AttributeConstant, Object> values = new HashMap<AttributeConstant, Object>();
        for (AttributeConstant attribute : attributes = this.getAttributeConstants()) {
            values.put(attribute, this.getValue(domainInstance, attribute));
        }
        return values;
    }

    @Override
    public OSRole<?> getParent() {
        return this.parentNode;
    }

    @Override
    public final RoleConstant getRoleConstant() {
        return this.roleConstant;
    }

    @Override
    public Map<AttributeConstant, Object> getValues(Object instance, AttributeConstant[] attributes) {
        HashMap<AttributeConstant, Object> values = new HashMap<AttributeConstant, Object>();
        for (AttributeConstant attribute : attributes) {
            values.put(attribute, this.getValue(instance, attribute));
        }
        return values;
    }

    @Override
    public void addChild(OSRole<?> child) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Can't add child that does not have this as parent.");
        }
        if (this.children.contains(child)) {
            throw new IllegalArgumentException("Child already added.");
        }
        this.children.add(child);
    }

    @Override
    public List<OSRole<?>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public OSRole<?> getChild(RoleConstant childRole) {
        for (OSRole<?> role : this.children) {
            if (role.getRoleConstant() != childRole) continue;
            return role;
        }
        return null;
    }

    @Override
    public T castToType(Object obj) {
        if (this.getDomainClass().isInstance(obj)) {
            return this.getDomainClass().cast(obj);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRoleConstant());
    }

    @Override
    public void setMainKey(Key mainKey) {
        if (this.keys == null) {
            this.keys = new ArrayList<Key>();
        } else if (this.keys.contains(mainKey)) {
            this.keys.remove(mainKey);
        }
        this.keys.add(0, mainKey);
    }

    @Override
    public Key getMainKey() {
        return this.getKeys().isEmpty() ? null : this.getKeys().get(0);
    }

    @Override
    public boolean equalsUsingKey(Key keyToUse, Object anObject, Object anOtherObject) {
        if (log.isTraceEnabled()) {
            log.trace(this + " equals using key " + keyToUse);
        }
        if (anObject == anOtherObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        boolean foundMatch = true;
        AttributeConstant[] attributes = keyToUse.getAttributes();
        for (int i = 0; i < attributes.length && foundMatch; ++i) {
            Object value1 = this.getValue(anObject, attributes[i]);
            Object value2 = this.getValue(anOtherObject, attributes[i]);
            boolean bl = foundMatch = KeyTool.isDefined(value1) && KeyTool.isDefined(value2);
            if (foundMatch) {
                foundMatch = value1.equals(value2);
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Comparing values in " + attributes[i] + ", value1: " + value1 + ", value2: " + value2 + ", equals so far: " + foundMatch);
        }
        return foundMatch;
    }

    protected Object getRelatedValue(Object domainObject, AttributeConstant attribute) {
        if (domainObject == null || attribute == null) {
            return null;
        }
        RoleConstant roleConst = this.getNextRelatedRole(attribute);
        OSRole<?> child = this.getChild(roleConst);
        if (child == null) {
            throw new IllegalArgumentException("Unknown related attribute: " + attribute + " for " + this);
        }
        return child.getValue(this.getRelation(domainObject, roleConst), attribute);
    }

    protected void setRelatedValue(Object domainObject, AttributeConstant attribute, Object value) {
        if (log.isTraceEnabled()) {
            log.trace("Setting related value " + attribute + " = " + value);
        }
        if (domainObject == null || attribute == null) {
            return;
        }
        RoleConstant roleConst = this.getNextRelatedRole(attribute);
        OSRole<?> child = this.getChild(roleConst);
        if (child == null) {
            throw new IllegalArgumentException("Unknown related attribute: " + attribute + " for " + this);
        }
        Object relatedObject = this.getRelation(domainObject, roleConst);
        if (relatedObject == null) {
            relatedObject = child.createNewInstance();
            this.setRelation(domainObject, relatedObject, roleConst);
            if (child.isNavigableToParent()) {
                child.setRelation(relatedObject, domainObject, this.getRoleConstant());
            }
        }
        child.setValue(relatedObject, attribute, value);
    }

    private RoleConstant getNextRelatedRole(AttributeConstant attribute) {
        List<RoleConstant> pathRoles = attribute.getAttributeRole().getRolePath();
        int ix = pathRoles.indexOf(this.getRoleConstant());
        if (pathRoles.isEmpty() || ix == pathRoles.size() - 1) {
            return null;
        }
        return pathRoles.get(ix + 1);
    }

    @Override
    public boolean isRelated(AttributeConstant attribute) {
        return this.isAncestorOf(attribute.getAttributeRole());
    }

    @Override
    public boolean isAncestorOf(RoleConstant possibleHeir) {
        if (possibleHeir == this.getRoleConstant()) {
            return false;
        }
        return this.possibleHeir(possibleHeir);
    }

    private boolean possibleHeir(RoleConstant possibleHeir) {
        if (this.getRoleConstant() == possibleHeir) {
            return true;
        }
        boolean found = false;
        Iterator<OSRole<?>> childIterator = this.children.iterator();
        while (!found && childIterator.hasNext()) {
            AbstractOSRole child = (AbstractOSRole)childIterator.next();
            found = child.possibleHeir(possibleHeir);
        }
        return found;
    }

    @Override
    public boolean isMany() {
        return this.getRelationCardinality().equals((Object)RelationCardinality.MANY);
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public OSRole<?> getRoot() {
        OSRole<Object> root = this;
        while (!root.isRoot()) {
            root = root.getParent();
        }
        return root;
    }

    @Override
    public void accept(Visitor<OSRole<?>> visitor) {
        visitor.visit(this);
    }

    @Override
    public void visitBranch(Visitor<OSRole<?>> visitor) {
        this.accept(visitor);
        List<OSRole<?>> children2 = this.getChildren();
        for (OSRole<?> role : children2) {
            role.visitBranch(visitor);
        }
    }
}

