/*
 * Decompiled with CFR 0.152.
 */
package no.g9.service.print;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import no.g9.exception.G9ServiceException;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageSystem;

public class JasperExplicitPrinterPrintManager
extends JRPrinterAWT {
    private JasperPrint jasperPrint;

    protected JasperExplicitPrinterPrintManager(JasperPrint jrPrint) throws JRException {
        super(jrPrint);
        this.jasperPrint = jrPrint;
    }

    public static void print(JasperPrint jrPrint, String printerName) {
        int lastPageIndex = jrPrint.getPages().size() - 1;
        try {
            JasperExplicitPrinterPrintManager.printPages(jrPrint, 0, lastPageIndex, printerName);
        }
        catch (JRException e) {
            throw new G9ServiceException(e);
        }
    }

    public static void printPages(JasperPrint jrPrint, int firstPageIndex, int lastPageIndex, String printerName) throws JRException {
        JasperExplicitPrinterPrintManager printer = new JasperExplicitPrinterPrintManager(jrPrint);
        printer.printPages(firstPageIndex, lastPageIndex, printerName);
    }

    private void printPages(int firstPageIndex, int lastPageIndex, String printerName) throws G9ServiceException {
        if (firstPageIndex < 0 || firstPageIndex > lastPageIndex || lastPageIndex >= this.jasperPrint.getPages().size()) {
            throw new G9ServiceException("Invalid page index range : " + firstPageIndex + " - " + lastPageIndex + " of " + this.jasperPrint.getPages().size());
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        JasperExplicitPrinterPrintManager.initPrinterJobFields((PrinterJob)printJob);
        PrintService[] pservices = PrintServiceLookup.lookupPrintServices(null, null);
        boolean found = false;
        if (pservices.length > 0) {
            for (int i = 0; i < pservices.length; ++i) {
                System.err.println(pservices[i].getName());
                String name = pservices[i].getName();
                if (!printerName.equals(name) && !this.matchEnd(printerName, name)) continue;
                try {
                    printJob.setPrintService(pservices[i]);
                    found = true;
                    break;
                }
                catch (PrinterException e) {
                    this.getMessageDispatcher().dispatch("-2008", printerName);
                    throw new G9ServiceException(e);
                }
            }
        }
        if (!found) {
            this.getMessageDispatcher().dispatch("-2009", printerName);
        }
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printJob.setJobName("JasperReports - " + this.jasperPrint.getName());
        switch (this.jasperPrint.getOrientationValue()) {
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append((Printable)((Object)this), pageFormat, lastPageIndex - firstPageIndex + 1);
        printJob.setPageable(book);
        try {
            printJob.print();
        }
        catch (Exception ex) {
            throw new G9ServiceException("Error printing report.", ex);
        }
    }

    private MessageDispatcher getMessageDispatcher() {
        return MessageSystem.getMessageDispatcher(null);
    }

    boolean matchEnd(String lookupName, String pPrinterName) {
        return pPrinterName.toLowerCase().endsWith(lookupName.toLowerCase());
    }
}

