/*
 * Decompiled with CFR 0.152.
 */
package no.g9.service.print;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ServiceException;
import no.g9.message.Message;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageSystem;
import no.g9.service.print.G9ExportManager;
import no.g9.service.print.G9Print;
import no.g9.service.print.JasperExplicitPrinterPrintManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JasperReportsPrint
implements G9Print {
    protected static final Locale DEFAULT_XML_LOCALE = Locale.getDefault();
    protected static final Locale DEFAULT_REPORT_LOCALE = Locale.getDefault();
    protected static final String JASPER_SUFFIX = ".jasper";

    @Override
    public boolean printReport(Document data, Map<String, Object> params, String dialogName, String printerName) {
        JasperPrint print = this.fillReport(data, params, dialogName);
        try {
            if (printerName == null) {
                return JasperPrintManager.printReport((JasperPrint)print, (boolean)true);
            }
            JasperExplicitPrinterPrintManager.print(print, printerName);
        }
        catch (Exception e) {
            Message message = MessageSystem.getMessageFactory().getMessage("-2001", new Object[0]);
            this.getMessageDispatcher().dispatch(message);
            throw new G9ServiceException(e, message);
        }
        return true;
    }

    @Override
    public boolean printReport(URI data, Map<String, Object> params, String dialogName, String printerName) {
        return this.printReport(this.getDocumentFromURI(data), params, dialogName, printerName);
    }

    @Override
    public boolean printReport(String data, Map<String, Object> params, String dialogName, String printerName) {
        return this.printReport(this.getDocumentFromXML(data), params, dialogName, printerName);
    }

    protected JasperPrint fillReport(Document data, Map<String, Object> params, String dialogName) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if (!params.containsKey("XML_LOCALE")) {
            params.put("XML_LOCALE", DEFAULT_XML_LOCALE);
        }
        if (!params.containsKey("REPORT_LOCALE")) {
            params.put("REPORT_LOCALE", DEFAULT_REPORT_LOCALE);
        }
        params.put("XML_DATA_DOCUMENT", data);
        try {
            long s = System.currentTimeMillis();
            JasperPrint print = JasperFillManager.fillReport((JasperReport)this.getReport(dialogName), params);
            this.removeBlankPage(print);
            Message msg = MessageSystem.getMessageFactory().getMessage("-2007", new Long(System.currentTimeMillis() - s));
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            return print;
        }
        catch (Exception e) {
            this.getMessageDispatcher().dispatch("-2002", e, new Object[0]);
            throw new G9ServiceException(e);
        }
    }

    protected JasperReport getReport(String dialogName) {
        ClassLoader cl = JasperReportsPrint.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(dialogName + JASPER_SUFFIX);
        if (in == null) {
            throw new G9BaseException("Unable to load compiled report template file \"" + dialogName + JASPER_SUFFIX + "\" (add this file to class path)");
        }
        JasperReport jasperReport = null;
        try {
            jasperReport = (JasperReport)JRLoader.loadObject((InputStream)in);
        }
        catch (JRException e) {
            throw new G9BaseException("Error loading report template class from file \"" + dialogName + JASPER_SUFFIX + "\"", e);
        }
        return jasperReport;
    }

    @Override
    public void exportPDF(Document data, String dialogName, File file, OutputStream os, Map<String, Object> params) {
        JasperPrint print = this.fillReport(data, params, dialogName);
        if (os == null && file == null) {
            Message msg = MessageSystem.getMessageFactory().getMessage("-2003", new Object[0]);
            throw new G9ServiceException(msg);
        }
        if (os == null) {
            try {
                G9ExportManager.exportReportToPdfFile(print, file);
            }
            catch (Exception e) {
                Message msg = MessageSystem.getMessageFactory().getMessage("-2004", new Object[0]);
                msg.setException(e);
                throw new G9ServiceException(e, msg);
            }
        }
        try {
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)os);
        }
        catch (Exception e) {
            Message msg = MessageSystem.getMessageFactory().getMessage("-2005", new Object[0]);
            msg.setException(e);
            throw new G9ServiceException(e, msg);
        }
    }

    protected Document getDocumentFromURI(URI data) {
        try {
            return JRXmlUtils.parse((String)data.getRawPath());
        }
        catch (Exception e) {
            Message msg = MessageSystem.getMessageFactory().getMessage("-2006", new Object[0]);
            msg.setException(e);
            throw new G9ServiceException(msg);
        }
    }

    protected Document getDocumentFromXML(String data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(data);
            return builder.parse(new InputSource(reader));
        }
        catch (FactoryConfigurationError e) {
            throw new G9ServiceException(e);
        }
        catch (ParserConfigurationException e) {
            throw new G9ServiceException(e);
        }
        catch (SAXException e) {
            throw new G9ServiceException(e);
        }
        catch (IOException e) {
            throw new G9ServiceException(e);
        }
    }

    protected MessageDispatcher getMessageDispatcher() {
        return MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION);
    }

    private void removeBlankPage(JasperPrint print) {
        List pages = print.getPages();
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            JRPrintPage page = (JRPrintPage)i.next();
            List elements = page.getElements();
            boolean has = false;
            for (JRPrintElement el : elements) {
                if (!(el instanceof JRTemplatePrintFrame) || el.getHeight() <= 0) continue;
                has = true;
                break;
            }
            if (has) continue;
            i.remove();
        }
    }
}

