/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import no.esito.log.Logger;
import no.esito.util.NumberFormat;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ServiceException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.service.G9Spring;
import no.g9.support.FormatHelper;
import no.g9.support.Pathfinder;
import no.g9.support.Registry;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertException;
import no.g9.support.convert.JasperConvertContext;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;

public class ReportHelper {
    private static final String IMAGE_PRE_PATH = "ImagePrePath";
    public static final String PROPERTY_FILE_NAME_CHECKBOX_UNCHECKED = "CheckButton.Image.Checked.FileName";
    public static final String PROPERTY_FILE_NAME_CHECKBOX_CHECKED = "CheckButton.Image.Unchecked.FileName";
    private static final String STRING_PRESENTATION_OF_NULL = "";
    private static Logger log = Logger.getLogger(ReportHelper.class);
    private static String CHECKBOX_TRUE_DEFAULT_IMAGE_FILENAME = "checkbox_true.jpg";
    private static String CHECKBOX_FALSE_DEFAULT_IMAGE_FILENAME = "checkbox_false.jpg";
    private static final String JODA_DATETIME = "org.joda.time.DateTime";
    private static final String JODA_DATEMIDNIGHT = "org.joda.time.DateMidnight";
    private static final String JAVATIME_LOCALDATE = "java.time.LocalDate";
    private static final String JAVATIME_LOCALTIME = "java.time.LocalTime";
    private static final String JAVATIME_LOCALDATETIME = "java.time.LocalDateTime";

    private ReportHelper() {
    }

    @Deprecated
    public static String format(Object data, String displayRule, int genovaDataType, int precision, int scale, int caseConversion, int fieldLength, boolean blankWhenZero) {
        return ReportHelper.format(data, displayRule, genovaDataType, null, precision, scale, caseConversion, fieldLength, blankWhenZero, null);
    }

    public static String format(Object data, String displayRule, int genovaDataType, String modelType, int precision, int scale, int caseConversion, int fieldLength, boolean blankWhenZero, String converterBeanName) {
        DateFormat df;
        if (log.isTraceEnabled()) {
            Object[] args = new Object[]{"data", data, "displayRule", displayRule, "genovaDataType", genovaDataType, "precision", precision, "scale", scale, "caseConversion", caseConversion, "fieldLength", fieldLength, "blankWhenZero", blankWhenZero};
            String parameters = Logger.formatParameters(args);
            log.trace("formatting: " + parameters);
        }
        if (data == null) {
            return STRING_PRESENTATION_OF_NULL;
        }
        block4 : switch (genovaDataType) {
            case 1: 
            case 2: 
            case 15: {
                if (data instanceof String) {
                    try {
                        data = Integer.decode((String)data);
                        break;
                    }
                    catch (NumberFormatException e) {
                        log.debug("Assuming un-parsable shortint/longint (\"" + data + "\") is pre-formatted.");
                        return (String)data;
                    }
                }
                if (data instanceof Integer) break;
                log.error("Can not format " + data.getClass() + " to Long (String or Integer expected)");
                return data.toString();
            }
            case 3: 
            case 4: 
            case 5: {
                if (data instanceof String) {
                    try {
                        data = new BigDecimal((String)data);
                        break;
                    }
                    catch (NumberFormatException e) {
                        log.debug("Assuming un-parsable numeric/real/double (\"" + data + "\") is pre-formatted.");
                        return (String)data;
                    }
                }
                if (data instanceof Long) break;
                log.error("Can not format " + data.getClass() + " to BigDecimal (String or BigDecimal expected)");
                return data.toString();
            }
            case 6: 
            case 7: {
                if (data instanceof String) break;
                data = data.toString();
                break;
            }
            case 9: {
                if (data instanceof String) {
                    if (data.equals("true")) {
                        data = Boolean.TRUE;
                        break;
                    }
                    if (data.equals("false")) {
                        data = Boolean.FALSE;
                        break;
                    }
                    log.debug("Assuming unknown value for boolean (\"" + data + "\") is pre-formatted.");
                    return (String)data;
                }
                if (data instanceof Boolean) break;
                log.error("Can not format " + data.getClass() + " to Boolean (String or Boolean expected)");
                return data.toString();
            }
            case 10: {
                if (!(data instanceof String)) {
                    data = data.toString();
                }
                genovaDataType = 6;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                if (data instanceof String) {
                    String sdata = (String)data;
                    try {
                        switch (modelType) {
                            case "java.time.LocalDate": {
                                data = LocalDate.parse(sdata);
                                break block4;
                            }
                            case "java.time.LocalTime": {
                                data = LocalTime.parse(sdata);
                                break block4;
                            }
                            case "java.time.LocalDateTime": {
                                data = LocalDateTime.parse(sdata);
                                break block4;
                            }
                            case "org.joda.time.DateTime": {
                                data = DateTime.parse((String)sdata);
                                break block4;
                            }
                            case "org.joda.time.DateMidnight": {
                                data = DateMidnight.parse((String)sdata);
                                break block4;
                            }
                        }
                        df = new SimpleDateFormat();
                        data = df.parse(sdata);
                        break;
                    }
                    catch (IllegalArgumentException | ParseException | DateTimeParseException e) {
                        log.info("Assuming un-parsable date/time/timestamp (\"" + data + "\") is pre-formatted.");
                        return (String)data;
                    }
                }
                if (data instanceof Date) break;
                log.error("Can not format " + data.getClass() + " to Date (String or Date expected)");
                return data.toString();
            }
            case 14: {
                log.info("Unsupported data type in report (blob)");
                return STRING_PRESENTATION_OF_NULL;
            }
            default: {
                log.error("Unknown data type: " + genovaDataType);
                return STRING_PRESENTATION_OF_NULL;
            }
        }
        if (converterBeanName != null) {
            AttributeConverter converter = (AttributeConverter)G9Spring.getBean(converterBeanName);
            JasperConvertContext context = new JasperConvertContext(displayRule, genovaDataType, precision, scale, caseConversion, fieldLength, blankWhenZero);
            Object fromModel = null;
            try {
                log.debug("Calling converter " + converterBeanName);
                fromModel = converter.fromModel(data, context);
            }
            catch (ConvertException e) {
                e.printStackTrace();
            }
            if (!converter.getTargetType().isAssignableFrom(converter.getModelType()) || converter.getTargetType().equals(String.class)) {
                return fromModel != null ? fromModel.toString() : null;
            }
            if (fromModel == null) {
                return null;
            }
            data = fromModel;
        }
        displayRule = FormatHelper.getDisplayrule(genovaDataType, displayRule, fieldLength, precision, scale);
        switch (genovaDataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                NumberFormat numberFormat = new NumberFormat(genovaDataType, displayRule);
                return numberFormat.format(FormatHelper.getNumericFormat(displayRule), data, false);
            }
            case 11: 
            case 12: 
            case 13: {
                String javaFormat = FormatHelper.getDatetimeFormat(displayRule);
                Locale locale = Locale.getDefault();
                df = javaFormat == null ? (genovaDataType == 11 ? DateFormat.getDateInstance(2) : (genovaDataType == 12 ? DateFormat.getTimeInstance(2) : DateFormat.getDateTimeInstance(2, 2))) : new SimpleDateFormat(javaFormat, locale);
                if (JODA_DATETIME.equals(modelType)) {
                    return df.format(((DateTime)data).toDate());
                }
                if (JODA_DATEMIDNIGHT.equals(modelType)) {
                    return df.format(((DateMidnight)data).toDate());
                }
                if (JAVATIME_LOCALDATE.equals(modelType)) {
                    LocalDate ld = (LocalDate)data;
                    return javaFormat != null ? ld.format(DateTimeFormatter.ofPattern(javaFormat)) : ld.toString();
                }
                if (JAVATIME_LOCALTIME.equals(modelType)) {
                    LocalTime lt = (LocalTime)data;
                    return javaFormat != null ? lt.format(DateTimeFormatter.ofPattern(javaFormat)) : lt.toString();
                }
                if (JAVATIME_LOCALDATETIME.equals(modelType)) {
                    LocalDateTime ldt = (LocalDateTime)data;
                    return javaFormat != null ? ldt.format(DateTimeFormatter.ofPattern(javaFormat)) : ldt.toString();
                }
                return df.format(data);
            }
            case 6: 
            case 7: 
            case 8: {
                return ReportHelper.formatToString((String)data, fieldLength, caseConversion);
            }
            case 10: {
                return data.toString();
            }
        }
        throw new G9BaseException("Failed to format " + data + " to string");
    }

    private static String formatToString(String data, int fieldLength, int caseConversion) {
        if (data == null) {
            return STRING_PRESENTATION_OF_NULL;
        }
        String result = data.trim();
        if (fieldLength < result.length()) {
            result = result.substring(0, fieldLength);
        }
        switch (caseConversion) {
            case -1: {
                result = result.toLowerCase(Locale.getDefault());
                break;
            }
            case 1: {
                result = result.toUpperCase(Locale.getDefault());
                break;
            }
        }
        return result;
    }

    public static String format(Object data, String labels) {
        if (data == null) {
            return STRING_PRESENTATION_OF_NULL;
        }
        String[] split = labels.split(",");
        for (int i = 0; i < split.length; i += 2) {
            if (!split[i].equals(data)) continue;
            return split[i + 1];
        }
        return "???<" + data + ">";
    }

    public static String getButtonImage(String boolString, String selectedImageName, String unselectedImageName) {
        Boolean b = Boolean.valueOf(boolString);
        return b != false ? ReportHelper.getImage(selectedImageName) : ReportHelper.getImage(unselectedImageName);
    }

    public static String getImage(String filename) {
        URL resourceReference = null;
        try {
            resourceReference = Pathfinder.getResourceReference(IMAGE_PRE_PATH, filename);
            filename = Pathfinder.getAbsoluteFilePath(resourceReference);
        }
        catch (G9ServiceException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                return resourceReference == null ? null : resourceReference.toExternalForm();
            }
            throw e;
        }
        if (!new File(filename).exists()) {
            Message msg = MessageSystem.getMessageFactory().getMessage("-2010", filename);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            return null;
        }
        return filename;
    }

    public static String getCheckBoxImageFilename(Boolean b) {
        String filename = Registry.getRegistry().getG9Property(b != false ? PROPERTY_FILE_NAME_CHECKBOX_CHECKED : PROPERTY_FILE_NAME_CHECKBOX_UNCHECKED);
        if (filename == null) {
            filename = b != false ? CHECKBOX_TRUE_DEFAULT_IMAGE_FILENAME : CHECKBOX_FALSE_DEFAULT_IMAGE_FILENAME;
        }
        URL resourceReference = null;
        try {
            resourceReference = Pathfinder.getResourceReference(IMAGE_PRE_PATH, filename);
            filename = Pathfinder.getAbsoluteFilePath(resourceReference);
        }
        catch (G9ServiceException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                return resourceReference == null ? null : resourceReference.toExternalForm();
            }
            throw e;
        }
        if (!new File(filename).exists()) {
            Message msg = MessageSystem.getMessageFactory().getMessage("-2010", filename);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            return null;
        }
        return filename;
    }

    public static String getCheckBoxImageFilename(String s) {
        return ReportHelper.getCheckBoxImageFilename(Boolean.valueOf(s));
    }
}

