/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.convert;

import java.util.HashMap;
import no.g9.support.convert.OSConvertContext;
import no.g9.support.convert.SimpleValueConverter;
import no.g9.support.convert.ValueConverter;

public class ConverterRegistry {
    private ValueConverter defaultConverter;
    private HashMap<String, ConvertersForOneAttribute> convertersForAttributes = new HashMap();

    public ConverterRegistry() {
        this.defaultConverter = new SimpleValueConverter();
    }

    public ConverterRegistry(ValueConverter defaultConverter) {
        this.defaultConverter = defaultConverter;
    }

    public synchronized ConverterRegistry registerRoleConverterForAttribute(String attributeName, String roleName, ValueConverter converter) {
        ConvertersForOneAttribute c = this.convertersForAttributes.get(attributeName);
        if (c == null) {
            c = new ConvertersForOneAttribute();
            this.convertersForAttributes.put(attributeName, c);
        }
        c.roleConverters.put(roleName, converter);
        return this;
    }

    public synchronized ConverterRegistry registerOsConverterForAttribute(String attributeName, String osName, ValueConverter converter) {
        ConvertersForOneAttribute c = this.convertersForAttributes.get(attributeName);
        if (c == null) {
            c = new ConvertersForOneAttribute();
            this.convertersForAttributes.put(attributeName, c);
        }
        c.osConverters.put(osName, converter);
        return this;
    }

    public synchronized ConverterRegistry registerClassConverterForAttribute(String attributeName, String className, ValueConverter converter) {
        ConvertersForOneAttribute c = this.convertersForAttributes.get(attributeName);
        if (c == null) {
            c = new ConvertersForOneAttribute();
            this.convertersForAttributes.put(attributeName, c);
        }
        c.classConverters.put(className, converter);
        return this;
    }

    public synchronized ConverterRegistry registerGlobalConverterForAttribute(String attributeName, ValueConverter converter) {
        ConvertersForOneAttribute c = this.convertersForAttributes.get(attributeName);
        if (c == null) {
            c = new ConvertersForOneAttribute();
            this.convertersForAttributes.put(attributeName, c);
        }
        c.globalConverter = converter;
        return this;
    }

    public synchronized ValueConverter getConverter(OSConvertContext context) {
        String className;
        ConvertersForOneAttribute c = this.convertersForAttributes.get(context.getAttributeName());
        if (c == null) {
            return this.defaultConverter;
        }
        if (c.roleConverters.containsKey(context.getRoleName())) {
            return c.roleConverters.get(context.getRoleName());
        }
        if (c.osConverters.containsKey(context.getObjectSelectionName())) {
            return c.osConverters.get(context.getObjectSelectionName());
        }
        if (context.getDomainObject() != null && c.classConverters.containsKey(className = context.getDomainObject().getClass().getName())) {
            return c.classConverters.get(className);
        }
        if (c.globalConverter != null) {
            return c.globalConverter;
        }
        return this.defaultConverter;
    }

    public synchronized void setDefaultValueConverter(ValueConverter defaultConverter) {
        this.defaultConverter = defaultConverter;
    }

    private static class ConvertersForOneAttribute {
        public HashMap<String, ValueConverter> roleConverters = new HashMap();
        public HashMap<String, ValueConverter> classConverters = new HashMap();
        public HashMap<String, ValueConverter> osConverters = new HashMap();
        public ValueConverter globalConverter = null;

        private ConvertersForOneAttribute() {
        }
    }
}

