/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.jetty;

import java.io.FileNotFoundException;
import java.net.URL;
import no.g9.support.Pathfinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyStart {
    private static Log log;

    public static void main(String[] args) {
        log = LogFactory.getLog(JettyStart.class);
        try {
            new JettyStart().go();
        }
        catch (Exception e) {
            log.fatal((Object)("Could not start the Jetty server: " + e));
        }
    }

    protected void go() throws Exception {
        XmlConfiguration jettyConfig = this.makeConfig();
        Server jettyServer = new Server();
        this.setupServer(jettyServer);
        this.configureServer(jettyConfig, jettyServer);
        try {
            jettyServer.start();
            jettyServer.join();
        }
        catch (Exception e) {
            try {
                jettyServer.stop();
            }
            catch (Exception e1) {
                log.fatal((Object)("Unable to stop the jetty server: " + e1));
            }
            throw e;
        }
    }

    protected void setupServer(Server jettyServer) {
        jettyServer.setStopAtShutdown(true);
    }

    protected void configureServer(XmlConfiguration jettyConfig, Server jettyServer) throws Exception {
        jettyConfig.configure((Object)jettyServer);
    }

    protected XmlConfiguration makeConfig() throws Exception {
        URL jettyConfig = Pathfinder.getResourceReference(null, "jetty-config.xml");
        if (jettyConfig == null) {
            throw new FileNotFoundException("Unable to locate jetty-config.xml on the classpath");
        }
        return new XmlConfiguration(jettyConfig);
    }

    static {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
    }
}

