/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class JavaEnumToJavaEnumConverterFactory
implements ConverterFactory<Enum, Enum> {
    public <T extends Enum> Converter<Enum, T> getConverter(Class<T> targetType) {
        return new JavaEnumToJavaEnumConverter<T>(targetType);
    }

    private static final class JavaEnumToJavaEnumConverter<T extends Enum>
    implements Converter<Enum, T> {
        private Class<T> enumType;

        public JavaEnumToJavaEnumConverter(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(Enum source) {
            return Enum.valueOf(this.enumType, source.name());
        }
    }
}

