/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.xml;

import java.util.ArrayList;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;
import no.g9.support.convert.ConverterRegistry;
import no.g9.support.convert.OSConvertContext;
import no.g9.support.convert.SimpleValueConverter;
import no.g9.support.convert.ValueConverter;
import no.g9.support.filter.AttributeFilter;
import no.g9.support.filter.RoleFilter;
import no.g9.support.xml.XmlConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXmlConverter
implements XmlConverter {
    protected ArrayList<AttributeFilter> attributeFilters;
    protected ArrayList<RoleFilter> roleFilters = new ArrayList();
    protected ConverterRegistry converterRegistry;

    protected AbstractXmlConverter() {
        this.attributeFilters = new ArrayList();
        this.converterRegistry = new ConverterRegistry(new SimpleValueConverter());
    }

    @Override
    public abstract Document convert(ObjectSelection var1, ClientContext var2);

    protected AbstractXmlConverter addRoleFilter(RoleFilter filter) {
        this.roleFilters.add(filter);
        return this;
    }

    protected AbstractXmlConverter addAttributeFilter(AttributeFilter filter) {
        this.attributeFilters.add(filter);
        return this;
    }

    protected void setConverterRegistry(ConverterRegistry converterRegistry) {
        this.converterRegistry = converterRegistry;
    }

    protected boolean isRoleIncluded(String roleName, Object domainObject) {
        for (RoleFilter rf : this.roleFilters) {
            if (rf.isRoleIncluded(roleName, domainObject)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAttributeIncluded(String attributeName, Object domainObject) {
        for (AttributeFilter af : this.attributeFilters) {
            if (af.isAttributeIncluded(attributeName, domainObject)) continue;
            return false;
        }
        return true;
    }

    protected String convertObjectToString(Object value, OSConvertContext context) {
        ValueConverter converter = this.converterRegistry.getConverter(context);
        return converter.convertToString(value, context);
    }

    protected Node makeAttributeNode(Object attrValue, Document doc, OSConvertContext oSConvertContext) {
        if (!this.isAttributeIncluded(oSConvertContext.getRoleName() + "." + oSConvertContext.getAttributeName(), oSConvertContext.getDomainObject())) {
            return null;
        }
        String value = this.convertObjectToString(attrValue, oSConvertContext);
        if (value == null) {
            return null;
        }
        Element n = doc.createElement(oSConvertContext.getAttributeName());
        n.appendChild(doc.createTextNode(value));
        return n;
    }
}

