/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.util;

/**
 * Utility class used by the generated Const classes.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public abstract class Const {

    /**
     * Returns the ordinal of the enum whose title 
     * (viz. <code>toString()</code>) equals the specified title.
     *
     * @param values array of enums
     * @param title the enum title.
     * @return the enum ordinal number
     */
    public static int ordinalByTitle(Enum<?>[] values, String title) {
        for (int i = 0; i < values.length; i++) {
            if (values[i].toString().equals(title)) {
                return i;
            }
        }
        return -1;
    }

    /**
     * Returns an array of enum titles 
     * (viz. the enum's <code>toString()</code>).
     * 
     * @param values array of enum values.
     * @return an array of enum titles.
     */
    public static String[] getTitles(Enum<?>[] values) {
        String[] titles = new String[values.length];
        for (int i = 0; i < values.length; i++) {
            titles[i] = values[i].toString();
        }
        
        return titles;
    }
    
}
