/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.util;

/**
 * Various internal String utility methods. 
 * 
 * <p><strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public abstract class StringUtil {

    /** The default separator to use between string parts. */
    public static final String DEFAULT_SEPARATOR = " ";

    /**
     * Remove camel casing from a string, adding the given separator
     * between the string parts.
     *
     * @param str the source string
     * @param sep the separator to be used, or null to use the default (space)
     * @return an "un-camelized" version of the source string 
     */
    public static final String unCamelize(String str, String sep) {
        if (sep == null) {
            sep = StringUtil.DEFAULT_SEPARATOR;
        }
        return str.replaceAll(String.format("%s|%s|%s",
              "(?<=[A-Z])(?=[A-Z][a-z])",
              "(?<=[^A-Z])(?=[A-Z])",
              "(?<=[A-Za-z])(?=[^A-Za-z])"), sep);
     }

    /**
     * Remove camel casing from a string, adding the default separator
     * between the string parts.
     *
     * @param str the source string
     * @return an "un-camelized" version of the source string 
     */
    public static final String unCamelize(String str) {
        return unCamelize(str, null);
     }

	/**
	 * Upper case the first character.
	 * 
	 * @param str the source string
	 * @return the string with an upper cased first letter
	 */
	public static String toFirstUpper(String str) {
		if (str == null || str.length() == 0)
			return str;
		if (Character.isUpperCase(str.charAt(0)))
			return str;
		if (str.length() == 1)
			return str.toUpperCase();
		return str.substring(0, 1).toUpperCase() + str.substring(1);
	}

}
