/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.domain;

/**
 * Keeps meta data for attributes from the domain model.
 * Normally, objects of this class are generated by g9 from the domain model.
 * 
 * This class is immutable.
 */
public final class AttributeInfo {

    /**
     * Possible values for the input and output justification property. 
     */
    public static enum JUSTIFICATION {
        /** Left justification */
        LEFT,
        /** Right justification */
        RIGHT,
        /** Centered justification */
        CENTER
    }

    /** The "Displayrule" property. */
    private final String displayRule;

    /** The "Blank When Zero" property. */
    private final boolean blankWhenZero;

    /** The "Input Justification" property. */
    private final JUSTIFICATION inputJustification;

    /** The "Output Justification" property. */
    private final JUSTIFICATION outputJustification;

    /**
     * Constructor. As this class is immutable, this is the only way to set the
     * field values for new objects.
     * 
     * @param displayRule - the "Displayrule" property.
     * @param blankWhenZero - the "Blank When Zero" property.
     * @param inputJustification - the "Input Justification" property. 
     * @param outputJustification - the "Output Justification" property. 
     */
    public AttributeInfo(String displayRule, boolean blankWhenZero,
            JUSTIFICATION inputJustification, JUSTIFICATION outputJustification) {
        super();
        this.displayRule = displayRule;
        this.blankWhenZero = blankWhenZero;
        this.inputJustification = inputJustification;
        this.outputJustification = outputJustification;
    }

    /**
     * @return the "Displayrule" property.
     */
    public String getDisplayRule() {
        return displayRule;
    }

    /**
     * @return the "Blank When Zero" property.
     */
    public boolean isBlankWhenZero() {
        return blankWhenZero;
    }

    /**
     * @return the "Input Justification" property.
     */
    public JUSTIFICATION getInputJustification() {
        return inputJustification;
    }

    /**
     * @return the "Output Justification" property.
     */
    public JUSTIFICATION getOutputJustification() {
        return outputJustification;
    }

}
