/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.domain;

import java.io.Serializable;

/**
 * Interface specifying the methods used with optimistic lock.
 * When GenerateLockFlag is specified in domain generator,
 * persistent domain classes should implement the methods in this interface.
 * However, the classes don't needs to specify the implementation of the
 * interface. The runtime uses reflections to see if the methods is implemented,
 * but specifying the implementation will have impact on the performance.
 */
public interface LockFlag {

     /**
     * Access method for the lockFlag property.
     *
     * @return   the current value of the lockFlag property
     */
    public Serializable getLockFlag();

    /**
     * Sets the value of the lockFlag property.
     *
     * @param aLockFlag the new value of the lockFlag property
     */
    public void setLockFlag(Serializable aLockFlag);
}
