/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;


/**
 * This interface is used by the message system to configure messages with data from different sources.
 * The <code>no.g9.message.MessageFactory</code> iterates trough all registered configurators until one of then retruns true.
 */
public interface MessageConfigurator {

	/**
	 * Lets the message configurator configure the provided message. 
	 * If the message configuration is finished this method should return true, if not it should return false.
	 * 
	 * @param message The message to configure.
	 * @return True if the configuration is finished.
	 */
	public boolean configure(Message message);

}