/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;


/**
 * Enumeration of the set of standard message types.
 */
public enum MessageTypeEnum implements MessageType {

	/** Messages intended for system log */
	SYSTEM_LOG,
	/** Interactive messages */
	INTERACTIVE,
	/** Messages intended for logging */
	LOG,
	/** Default message type */
	DEFAULT,

	/** Message type: Question - Icon = Question mark. */
	QUESTION,

	/** Message type: Warning with alternatives - Icon = Warning. */
	QWARN,

	/** Message type: No specified message type. */
	NONE,

	/** Message type: Info message - Icon = Info. */
	INFO,

	/** Message type: Error message */
	ERROR,

	/** Message type: Log only = Security warning. */
	SECURITY,

	/** Message type: Debug. */
	DEBUG,

	/** Message type: Status line. */
	STATUS,

	/** Message type: Progress. */
	PROGRESS,

	/** Message type: Timer. */
	TIMER,

	/** Message type: Inline type messages */
    INLINE;


	/**
	 * This function retuns the <code>MessageType</code> for a given name.
	 * @param pName The name of the <code>MessageType</code>.
	 * @return The <code>MessageType</code>. This can be null if the name does not match.
	 */
	public static MessageType fromString(String pName) {
		return MessageTypeEnum.valueOf(pName.toUpperCase());
	}
}