/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message.administration;

import java.util.List;

import no.g9.message.MessageConfigurator;
import no.g9.message.MessageInteractor;
import no.g9.message.MessageLogger;

/**
 * Administrative interface for the message system.
 */
public interface IMessageAdmin {

    /**
     * @return the current message interactor.
     */
    MessageInteractor getInteractor();

    /**
     * Set the message interactor.
     *
     * @param msgInteractor (missing javadoc)
     */
    void setInteractor(MessageInteractor msgInteractor);

    /**
     * @return the list of loggers currently used.
     */
    List<MessageLogger> getLoggers();

    /**
     * Set the loggers list.
     *
     * @param loggers (missing javadoc)
     * @throws NullPointerException if <code>loggers</code> is null.
     */
    void setLoggers(List<MessageLogger> loggers);

    /**
     * Clear the loggers list.
     */
    void clearLoggers();

    /**
     * Add a logger to the loggers list.
     *
     * @param logger (missing javadoc)
     */
    void addLogger(MessageLogger logger);

    /**
     * @return the list of providers currently used.
     */
    List<MessageConfigurator> getProviders();

    /**
     * Set the providers list.
     *
     * @param providers (missing javadoc)
     * @throws NullPointerException if <code>providers</code> is null.
     */
    void setProviders(List<MessageConfigurator> providers);

    /**
     * Clear the providers list.
     */
    void clearProviders();

    /**
     * Add a provider to the providers list.
     *
     * @param provider (missing javadoc)
     */
    void addProvider(MessageConfigurator provider);

}