/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.os;

import java.util.List;

import no.g9.support.action.ActionTarget;

/**
 * A tagging interface used to tag the generated role enumerations.
 */
public interface RoleConstant extends OSConstant, ActionTarget {

    /**
     * Gets the role path for this object selection role. The role path is a
     * List of role constants describing the path from a many- or root-role down
     * to and including this role (the many-role or root-role is not part of the
     * path).
     * 
     * @return the role path to this role.
     */
    List<RoleConstant> getRolePath();
    
    
    /**
     * Test if this constant represents an object selection or a role.
     * @return <code>true</code> if this constant represents an object selection.
     */
    boolean isObjectSelection();

}
