/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.service.print;

import java.io.File;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;

/**
 * This class should be omitted when JasperReports (JasperExportManager)
 * supports file input on export.
 */
public class G9ExportManager {

    /**
     * Exports the generated report file specified by the first parameter into PDF format,
     * the result being placed in the second file parameter.
     *
     * @param jasperPrint  report object to export 
     * @param destFile file to place the PDF content into
     * @throws JRException lack of destination or export failure results in exception
     * @see net.sf.jasperreports.engine.export.JRPdfExporter
     */
    public static void exportReportToPdfFile(JasperPrint jasperPrint,
                                             File destFile)
                            throws JRException {
        JRPdfExporter exporter= new JRPdfExporter();
        
        exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(destFile));
        exporter.exportReport();
    }
}
