/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.service.print;


/**
 * Remote interface for printing.
 */
public interface PrintRemoteService {

    /**
     * Fills the template with the data and prints on the printer specified.
     *
     *
     * @param data          Data as XML to be printed formed in a file
     * @param dialogName    The template to be filled and printed
     * @param printerName   The name of the printer
     */
    public void print(String data, String dialogName, String printerName);

//    /**
//     * Fills the template with the data and prints on the printer specified.
//     *
//     *
//     * @param data         Data as XML to be printed formed in a file
//     * @param dialogName   The template to be filled and printed
//     * @param printerName  The name of the printer
//     * @param params       Parameters to supplement the data towards the print
//     */
//    public void print(String data,
//                      String dialogName,
//                      String printerName,
//                      Map<Object, Object> params);
}
