/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;



/**
 * Enumerate the action types.
 */
public enum ActionType {

    /**
     * The activate action. This action type should be used by developers who
     * wish to implement every aspect of the action.
     */
    @ActionTypeInfo(HookType.NONE)
    ACTIVATE,

    /**
     * The clear object action. This action clears the gui object.
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    CLEAROBJECT,

    /**
     * The clear action. Clears the object selection role recursively.
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE})
    CLEAR,

    /**
     * The close action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE })
    CLOSE,

    /**
     * The collapse action.
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    COLLAPSE,

    /**
     * The connect action.
     */
    @ActionTypeInfo(HookType.NONE)
    CONNECT,
    
    /**
     * The delete action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    DELETE,

    /**
     * The disable action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    DISABLE,

    /**
     * The disconnect action.
     */
    @ActionTypeInfo(HookType.NONE)
    DISCONNECT,


    /**
     * The enable action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    ENABLE,

    /**
     * The exit application action
     */
    @ActionTypeInfo({HookType.HOOKABLE, HookType.CHECKABLE})
    EXIT,

    /**
     * The expand action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    EXPAND,
    
    /**
     * The exportToSpreadsheet action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE, HookType.OBTAINABLE })
    EXPORTTOSPREADSHEET,

    /**
     * The find action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    FIND,

    /**
     * The find all action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    FINDALL,

    /**
     * The focus action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    FOCUS,

    /**
     * The hide action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    HIDE,

    /**
     * The insert action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    INSERT,

    /**
     * The insert row action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    INSERTROW,

    /**
     * The invoke action
     */
    @ActionTypeInfo({HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE})
    INVOKE,

    /**
     * The open action
     */
    @ActionTypeInfo({HookType.HOOKABLE, HookType.CHECKABLE, HookType.PARAMETERIZED})
    OPEN,

    /**
     * The print action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE })
    PRINT,

    /**
     * The remove row action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    REMOVEROW,

    /**
     * The save action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    SAVE,

    /**
     * The show action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    SHOW,

    /**
     * The update action
     */
    @ActionTypeInfo( { HookType.HOOKABLE, HookType.CHECKABLE,
            HookType.OBTAINABLE, HookType.CLEARABLE, HookType.DISPLAYABLE })
    UPDATE,

    /////////////////// JVine Actions //////////////////////////////
    /**
     * The check save action
     */
    @ActionTypeInfo(HookType.CHECKABLE)
    @Deprecated
    CHECK_SAVE,

    /**
     * The check find action
     */
    @ActionTypeInfo(HookType.CHECKABLE)
    @Deprecated
    CHECK_FIND,

    /**
     * The check delete action
     */
    @ActionTypeInfo(HookType.CHECKABLE)
    @Deprecated
    CHECK_DELETE,

    /**
     * The check close action
     */
    @ActionTypeInfo(HookType.CHECKABLE)
    @Deprecated
    CHECK_CLOSE,

    /**
     * The check clear action.
     *
     */
    @Deprecated
    @ActionTypeInfo(HookType.CHECKABLE)
    CHECK_CLEAR,
    /**
     * The obtain action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    @Deprecated
    OBTAIN,

    /**
     * The display action
     */
    @ActionTypeInfo(HookType.HOOKABLE)
    @Deprecated
    DISPLAY,

    /**
     * The (synthetic) select action.
     */
    @ActionTypeInfo({HookType.CHECKABLE, HookType.HOOKABLE})
    SELECT,
    
    /**
     * The (synthetic) unselect action.
     */
    @ActionTypeInfo({HookType.CHECKABLE, HookType.HOOKABLE})
    UNSELECT;

    /**
     * Returns the lower cased name of the action where underline is replaced
     * with a space. Intended for debug purposes.
     */
    @Override
    public String toString() {
        String name = name().toLowerCase();
        return name.replace('_', ' ');
    }
}