/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

/**
 * Utility class used for building a query.
 */
public class QueryTool {
    private boolean addedFrom;

    private boolean addedWhere;

    private StringBuffer fromClause;

    private StringBuffer whereClause;

    /**
     * Default constructor. Creates a new query tool instance.
     */
    public QueryTool() {
        initialize();

    }

    /**
     * Initializes the query tool.
     */
    public void initialize() {
        addedFrom = false;
        addedWhere = false;
        fromClause = new StringBuffer();
        whereClause = new StringBuffer();
    }

    /**
     * Appends the "from" clause.
     * @param tableName the name of the table
     */
    public void appendFromClause(String tableName) {
        if (addedFrom) {
            fromClause.append(" ,");
        } else {
            fromClause.append("from");
        }
        fromClause.append(" ");
        fromClause.append(tableName);
    }

    /**
     * Appends the "where" clause.
     * @param tableName the name of the table
     * @param attributeName the name of the attribute
     */
    public void appendWhereClause(String tableName, String attributeName) {
        if (addedWhere) {
            whereClause.append(" and");
        } else {
            whereClause.append(" where");
        }
        whereClause.append(" ");
        whereClause.append(tableName);
        whereClause.append(".");
        whereClause.append(attributeName);
        whereClause.append(" = ?");
    }

    /**
     * Gets the query string.
     * @return the query string.
     */
    public String getQueryString() {
        return fromClause.toString() + whereClause.toString();
    }
}
