/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

/**
 * The visitable part of the visitor pattern. 
 *
 * @param <T> The implementing type of the visitable.
 */
public interface Visitable<T> {
    
    /**
     * Accept a visitor and by invoking the vistor's visit method.
     * @param visitor the visitor visiting this visitable.
     * @see Visitor#visit(Object)
     */
    void accept(Visitor<T> visitor);

}
