/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

/**
 * General visitor. This interface represents the "visiting" part in
 * the visitor pattern. 
 * @param <T> The visitable type
 * 
 */
public interface Visitor<T> {
    
    /**
     * Callback from the visited object selection role. 
     * @param visitable the visited party.
     * @see Visitable#accept(Visitor)
     */
     void visit(T visitable);

     
}
