/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;


/**
 * Common interface for converters between model and other modules (for instance
 * view). Note that it is not needed to guarantee preservation of data through
 * the conversion. Meaning, a value object that goes through a round trip of
 * conversion will not necessary result in the original value.
 * @param <M> model type
 * @param <T> target type
 */
public interface AttributeConverter<M, T> extends Converter<M, T> {

    /**
     * Get the type this converter converts to (the non-model type).
     * @return the type this converter converts to (the non-model type)
     */
    public Class<T> getTargetType();

    /**
     * Returns the model type.
     * @return the model type
     */
    public Class<M> getModelType();

}
