/*
 * Copyright 2013-2020 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;

import no.g9.exception.G9BaseException;

/**
 * Wrapper class for AttributeConverter. Used to wrap an AttributeConverter
 * as a ValueConverter, thus enabling it to be used with ConverterRegistry.
 * 
 * @author maw
 * @param <M> model type 
 *
 */
public class AttributeConverterWrapper<M> implements ValueConverter {
    
    private AttributeConverter<M,String> attributeConverter;
    
    /**
     * Default constructor.
     * @param attributeConverter to be wrapped
     * 
     */
    public AttributeConverterWrapper(AttributeConverter<M,String> attributeConverter) {
        this.attributeConverter= attributeConverter;
    }

    @SuppressWarnings("unchecked")
    @Override
    public String convertToString(Object value, ConvertContext context) {
        try {
            return attributeConverter.fromModel((M)value, context);
        } catch (ConvertException e) {
            throw new G9BaseException(e);
        }
    }

    @Override
    public Object convertToObject(String value, ConvertContext context) {
        try {
            return attributeConverter.toModel(value, context);
        } catch (ConvertException e) {
            throw new G9BaseException(e);
        }
    }

}
